function[xrate, RL] = MotorRate(xtype, natt, fxs, kin1, kin2, kin3, DDB, dyn, kBT, xTest)
xrate = zeros(natt, 7);
RL = zeros(natt, 1);

for ii = 1:natt
    switch xtype(ii)
        case 1 % kin-1
            if fxs(ii) > 0 % assisting
                if xTest.kinChemMechStep == 1
                    xrate(ii, 1) = (kin1.k2^-1 + kin1.k3^-1)^-1; % forward rate with assist, (1/k2 + 1/k3)^-1
                    xrate(ii, 2) = 0; % no backstepping
                else
                    xrate(ii, 1) = kin1.ksf0;
                    xrate(ii, 2) = kin1.ksb0;
                end
                RL(ii) = kin1.L0(1)*exp(-abs(fxs(ii))*kin1.deltaL(1)/kBT); % runlength calculation
                if xTest.kinVoverRL_detach == 1
                    xrate(ii, 3) = 8*(xrate(ii, 1) - xrate(ii, 2))/RL(ii); % detach rate=V/RL
                else
                    xrate(ii, 3) = kin1.koff0(1)*exp(abs(fxs(ii)/kin1.Fdet(1))); % Andreasson's Exp form
                end
            else
                if xTest.kinChemMechStep == 1
                    xrate(ii, 1) = ((kin1.k2*exp(-abs(fxs(ii))*kin1.deltaV/kBT))^-1 + kin1.k3^-1)^-1; % forward rate with assist, (1/k2 + 1/k3)^-1
                    xrate(ii, 2) = kin1.ksb4*abs(fxs(ii))/4; % linear backstepping
                else
                    xrate(ii, 1) = (kin1.ksb0 - kin1.ksf0)*(abs(fxs(ii))/kin1.Fstall) + kin1.ksf0;
                    xrate(ii, 2) = kin1.ksb0;
                end
                if xrate(ii, 1) < 0 % no negative rate
                    xrate(ii, 1) = 0;
                end
                RL(ii) = kin1.L0(2)*exp(-abs(fxs(ii))*kin1.deltaL(2)/kBT);
                if xTest.kinVoverRL_detach == 1
                    xrate(ii, 3) = 8*(xrate(ii, 1) - xrate(ii, 2))/RL(ii);
                else
                    xrate(ii, 3) = kin1.koff0(2)*exp(abs(fxs(ii)/kin1.Fdet(2))); % Andreasson's Exp form
                end
            end
            if xrate(ii, 1) < 0 % no negative rate
                xrate(ii, 1) = 0;
            end

        case 2 % kin-2
            if fxs(ii) > 0 % assisting
                if xTest.kinChemMechStep == 1
                    xrate(ii, 1) = (kin2.k2^-1 + kin2.k3^-1)^-1; % forward rate with assist, (1/k2 + 1/k3)^-1
                    xrate(ii, 2) = 0; % no backstepping
                else
                    xrate(ii, 1) = kin2.ksf0;
                    xrate(ii, 2) = kin2.ksb0;
                end
                RL(ii) = kin2.L0*exp(-abs(fxs(ii))*kin2.deltaL(2)/kBT);
                if xTest.kinVoverRL_detach == 1
                    xrate(ii, 3) = 8*(xrate(ii, 1) - xrate(ii, 2))/RL(ii);
                else
                    xrate(ii, 3) = kin2.koff0(1)*exp(abs(fxs(ii)/kin2.Fdet)); % Andreasson's Exp form
                end
            else
                if xTest.kinChemMechStep == 1
                    xrate(ii, 1) = ((kin2.k2*exp(-abs(fxs(ii))*kin2.deltaV/kBT))^-1 + kin2.k3^-1)^-1; % forward rate with assist, (1/k2 + 1/k3)^-1
                    xrate(ii, 2) = kin2.ksb4*abs(fxs(ii))/4; % no backstepping
                else
                    xrate(ii, 1) = (kin2.ksb0 - kin2.ksf0)*(abs(fxs(ii))/kin2.Fstall) + kin2.ksf0;
                    xrate(ii, 2) = kin2.ksb0;
                end
                if xrate(ii, 1) < 0 % no negative rate
                    xrate(ii, 1) = 0;
                end
                RL(ii) = kin2.L0*exp(-abs(fxs(ii))*kin2.deltaL(2)/kBT);
                if xTest.kinVoverRL_detach == 1
                    xrate(ii, 3) = 8*(xrate(ii, 1) - xrate(ii, 2))/RL(ii);
                else
                    xrate(ii, 3) = kin2.koff0(2)*exp(abs(fxs(ii)/kin2.Fdet)); % Andreasson's Exp form
                end
            end
            if xrate(ii, 1) < 0 % no negative rate
                xrate(ii, 1) = 0;
            end

        case 3 % kin-3
            if fxs(ii) > 0 % assisting
                xrate(ii, 1) = kin3.ksf0;
            else
                xrate(ii, 1) = (kin3.ksb0 - kin3.ksf0)*(abs(fxs(ii))/kin3.Fstall) + kin3.ksf0;
            end
            if xrate(ii, 1) < 0 % no negative rate
                xrate(ii, 1) = 0;
            end
            xrate(ii, 2) = kin3.ksb0;
            xrate(ii, 3) = kin3.koff0*exp(abs(fxs(ii)/kin3.Fdet));

        case 4 % DDB
            xrate(ii, 2) = (DDB.Vmin/8)*(1 - exp(-(fxs(ii) - DDB.Fstall)*(DDB.deltaV/kBT))) + DDB.ksb0; % convert V to forward step
            if xTest.DDBExpVStep == 0 && fxs(ii) < 0 % assisting

            elseif xTest.DDBExpVStep == 0 && fxs(ii) >= 0 % hindering
                xrate(ii, 2) = (DDB.ksb0 - DDB.ksf0)*(abs(fxs(ii))/DDB.Fstall) + DDB.ksf0;
            end
            xrate(ii, 1) = DDB.ksb0;
            
            if xTest.DDBideal == 1
                xrate(ii, 3) = DDB.koff0;
            else
                xrate(ii, 3) = DDB.koff0*exp(abs(fxs(ii)/DDB.Fdet));
            end
            
            if xrate(ii, 2) < 0 % no negative rate
                xrate(ii, 2) = 0;
            end

        case 5 % dyn
            if fxs(ii) < 0 % assisting
                xrate(ii, 2) = dyn.ksf0;
            else
                if abs(fxs(ii)) > (dyn.Fstall*4/3)
                    xrate(ii, 2) = 0;
                else
                    xrate(ii, 2) = dyn.ksf0*(1 - abs(fxs(ii)/dyn.Fstall*(3/4)));
                end
            end
            xrate(ii, 1) = dyn.ksb0;
            xrate(ii, 3) = dyn.koff0*exp(abs(fxs(ii)/dyn.Fdet));
            if xrate(ii, 2) < 0 % no negative rate
                xrate(ii, 2) = 0;
            end
    end
end